/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class CodeUpdateModifyWizard
implements JDMWizardPanelDelegate {
    protected static ResourceBundle bundle = ResourceBundle.getBundle("ibm.nways.jdm8260.Resources");
    protected JdmBrowser browser;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        String string = "setDefaults";
        DestinationPropBook destinationPropBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        this.browser = (JdmBrowser)destinationPropBook.getBrowser();
        Hashtable hashtable = jDMWizardInfo.getItems();
        GenModel genModel = jDMWizardInfo.getModel();
        try {
            ModelInfo modelInfo = genModel.getInfo("Panel");
            if (hashtable != null) {
                hashtable.put("tftpSlot", modelInfo.get("Panel.TftpSlot"));
                hashtable.put("tftpSubSlot", modelInfo.get("Panel.TftpSubSlot"));
                hashtable.put("tftpIpAddress", modelInfo.get("Panel.TftpIpAddress"));
                hashtable.put("tftpFileName", modelInfo.get("Panel.TftpFileName"));
                hashtable.put("tftpFileType", modelInfo.get("Panel.TftpFileType"));
                hashtable.put("tftpTargetLocation", modelInfo.get("Panel.TftpTargetLocation"));
                hashtable.put("tftpModType", modelInfo.get("Panel.TftpModType"));
                hashtable.put("tftpStart", new Integer(1));
                hashtable.put("readytogo", "yes");
                this.displayMsg("TFTP_modifyConfirm");
                return;
            }
            this.displayMsg("TFTP_modifyNoConfirm");
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string, exception);
            return;
        }
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        this.displayMsg("TFTP_modifyAbort");
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        String string = "proceed";
        boolean bl = true;
        GenModel genModel = jDMWizardInfo.getModel();
        Hashtable hashtable = jDMWizardInfo.getItems();
        if (hashtable.get("readytogo").equals("yes")) {
            ModelInfo modelInfo = new ModelInfo();
            Object v = hashtable.get("tftpTargetLocation");
            int n = 0;
            if (v instanceof Integer) {
                n = (Integer)v;
            }
            modelInfo.add("Panel.TftpSlot", (Integer)hashtable.get("tftpSlot"));
            this.addToModelInfoIfValid(modelInfo, "Panel.TftpSubSlot", hashtable.get("tftpSubSlot"));
            modelInfo.add("Panel.TftpIpAddress", (IPAddress)hashtable.get("tftpIpAddress"));
            modelInfo.add("Panel.TftpFileName", (Serializable)((Object)((String)hashtable.get("tftpFileName"))));
            modelInfo.add("Panel.TftpFileType", (Integer)hashtable.get("tftpFileType"));
            this.addToModelInfoIfValid(modelInfo, "Panel.TftpTargetLocation", hashtable.get("tftpTargetLocation"));
            if (n == 3) {
                this.addToModelInfoIfValid(modelInfo, "Panel.TftpModType", hashtable.get("tftpModType"));
            }
            try {
                modelInfo = genModel.setInfo("Panel", modelInfo);
                bl = this.checkSetInfo(modelInfo);
                if (bl) {
                    modelInfo.removeAll();
                    modelInfo.add("Control.TftpStart", (Integer)hashtable.get("tftpStart"));
                    modelInfo = genModel.setInfo("Control", modelInfo);
                    bl = this.checkSetInfo(modelInfo);
                }
            }
            catch (Exception exception) {
                RAS.logException(19, 2, this, string, exception);
                bl = false;
            }
        }
        if (bl) {
            this.displayMsg("TFTP_modifyOK");
        } else {
            this.displayMsg("TFTP_modifyError");
        }
        return bl;
    }

    private void addToModelInfoIfValid(ModelInfo modelInfo, String string, Object object) {
        if (!(object instanceof SpecialValue)) {
            modelInfo.add(string, (Serializable)object);
        }
    }

    private boolean checkSetInfo(ModelInfo modelInfo) {
        String string = "checkSetInfo";
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string2);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Got a special value for ID -> " + string2);
            }
            return false;
        }
        return true;
    }

    protected void displayMsg(String string) {
        if (this.browser != null) {
            this.browser.displayMsg(CodeUpdateModifyWizard.getNLSString(string));
        }
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = bundle.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }
}

